package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchSetScdnDomainConfigs invokes the scdn.BatchSetScdnDomainConfigs API synchronously
func (client *Client) BatchSetScdnDomainConfigs(request *BatchSetScdnDomainConfigsRequest) (response *BatchSetScdnDomainConfigsResponse, err error) {
	response = CreateBatchSetScdnDomainConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// BatchSetScdnDomainConfigsWithChan invokes the scdn.BatchSetScdnDomainConfigs API asynchronously
func (client *Client) BatchSetScdnDomainConfigsWithChan(request *BatchSetScdnDomainConfigsRequest) (<-chan *BatchSetScdnDomainConfigsResponse, <-chan error) {
	responseChan := make(chan *BatchSetScdnDomainConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchSetScdnDomainConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchSetScdnDomainConfigsWithCallback invokes the scdn.BatchSetScdnDomainConfigs API asynchronously
func (client *Client) BatchSetScdnDomainConfigsWithCallback(request *BatchSetScdnDomainConfigsRequest, callback func(response *BatchSetScdnDomainConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchSetScdnDomainConfigsResponse
		var err error
		defer close(result)
		response, err = client.BatchSetScdnDomainConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchSetScdnDomainConfigsRequest is the request struct for api BatchSetScdnDomainConfigs
type BatchSetScdnDomainConfigsRequest struct {
	*requests.RpcRequest
	Functions     string           `position:"Query" name:"Functions"`
	DomainNames   string           `position:"Query" name:"DomainNames"`
	OwnerAccount  string           `position:"Query" name:"OwnerAccount"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// BatchSetScdnDomainConfigsResponse is the response struct for api BatchSetScdnDomainConfigs
type BatchSetScdnDomainConfigsResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	DomainConfigList DomainConfigList `json:"DomainConfigList" xml:"DomainConfigList"`
}

// CreateBatchSetScdnDomainConfigsRequest creates a request to invoke BatchSetScdnDomainConfigs API
func CreateBatchSetScdnDomainConfigsRequest() (request *BatchSetScdnDomainConfigsRequest) {
	request = &BatchSetScdnDomainConfigsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "BatchSetScdnDomainConfigs", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchSetScdnDomainConfigsResponse creates a response to parse from BatchSetScdnDomainConfigs response
func CreateBatchSetScdnDomainConfigsResponse() (response *BatchSetScdnDomainConfigsResponse) {
	response = &BatchSetScdnDomainConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
