package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateChannel invokes the rtc.UpdateChannel API synchronously
func (client *Client) UpdateChannel(request *UpdateChannelRequest) (response *UpdateChannelResponse, err error) {
	response = CreateUpdateChannelResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateChannelWithChan invokes the rtc.UpdateChannel API asynchronously
func (client *Client) UpdateChannelWithChan(request *UpdateChannelRequest) (<-chan *UpdateChannelResponse, <-chan error) {
	responseChan := make(chan *UpdateChannelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateChannel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateChannelWithCallback invokes the rtc.UpdateChannel API asynchronously
func (client *Client) UpdateChannelWithCallback(request *UpdateChannelRequest, callback func(response *UpdateChannelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateChannelResponse
		var err error
		defer close(result)
		response, err = client.UpdateChannel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateChannelRequest is the request struct for api UpdateChannel
type UpdateChannelRequest struct {
	*requests.RpcRequest
	ShowLog   string           `position:"Query" name:"ShowLog"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	Nonce     string           `position:"Query" name:"Nonce"`
	AppId     string           `position:"Query" name:"AppId"`
	ChannelId string           `position:"Query" name:"ChannelId"`
}

// UpdateChannelResponse is the response struct for api UpdateChannel
type UpdateChannelResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Nonce     string `json:"Nonce" xml:"Nonce"`
	Timestamp int    `json:"Timestamp" xml:"Timestamp"`
}

// CreateUpdateChannelRequest creates a request to invoke UpdateChannel API
func CreateUpdateChannelRequest() (request *UpdateChannelRequest) {
	request = &UpdateChannelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "UpdateChannel", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateChannelResponse creates a response to parse from UpdateChannel response
func CreateUpdateChannelResponse() (response *UpdateChannelResponse) {
	response = &UpdateChannelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
