package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetChannelProperty invokes the rtc.SetChannelProperty API synchronously
func (client *Client) SetChannelProperty(request *SetChannelPropertyRequest) (response *SetChannelPropertyResponse, err error) {
	response = CreateSetChannelPropertyResponse()
	err = client.DoAction(request, response)
	return
}

// SetChannelPropertyWithChan invokes the rtc.SetChannelProperty API asynchronously
func (client *Client) SetChannelPropertyWithChan(request *SetChannelPropertyRequest) (<-chan *SetChannelPropertyResponse, <-chan error) {
	responseChan := make(chan *SetChannelPropertyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetChannelProperty(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetChannelPropertyWithCallback invokes the rtc.SetChannelProperty API asynchronously
func (client *Client) SetChannelPropertyWithCallback(request *SetChannelPropertyRequest, callback func(response *SetChannelPropertyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetChannelPropertyResponse
		var err error
		defer close(result)
		response, err = client.SetChannelProperty(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetChannelPropertyRequest is the request struct for api SetChannelProperty
type SetChannelPropertyRequest struct {
	*requests.RpcRequest
	StartTime  requests.Integer `position:"Query" name:"StartTime"`
	MaxUserNum requests.Integer `position:"Query" name:"MaxUserNum"`
	Duration   requests.Integer `position:"Query" name:"Duration"`
	ShowLog    string           `position:"Query" name:"ShowLog"`
	Topics     string           `position:"Query" name:"Topics"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Priority   string           `position:"Query" name:"Priority"`
	AppId      string           `position:"Query" name:"AppId"`
	ChannelId  string           `position:"Query" name:"ChannelId"`
}

// SetChannelPropertyResponse is the response struct for api SetChannelProperty
type SetChannelPropertyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetChannelPropertyRequest creates a request to invoke SetChannelProperty API
func CreateSetChannelPropertyRequest() (request *SetChannelPropertyRequest) {
	request = &SetChannelPropertyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "SetChannelProperty", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetChannelPropertyResponse creates a response to parse from SetChannelProperty response
func CreateSetChannelPropertyResponse() (response *SetChannelPropertyResponse) {
	response = &SetChannelPropertyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
