package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRtcQualityMetric invokes the rtc.DescribeRtcQualityMetric API synchronously
func (client *Client) DescribeRtcQualityMetric(request *DescribeRtcQualityMetricRequest) (response *DescribeRtcQualityMetricResponse, err error) {
	response = CreateDescribeRtcQualityMetricResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRtcQualityMetricWithChan invokes the rtc.DescribeRtcQualityMetric API asynchronously
func (client *Client) DescribeRtcQualityMetricWithChan(request *DescribeRtcQualityMetricRequest) (<-chan *DescribeRtcQualityMetricResponse, <-chan error) {
	responseChan := make(chan *DescribeRtcQualityMetricResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRtcQualityMetric(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRtcQualityMetricWithCallback invokes the rtc.DescribeRtcQualityMetric API asynchronously
func (client *Client) DescribeRtcQualityMetricWithCallback(request *DescribeRtcQualityMetricRequest, callback func(response *DescribeRtcQualityMetricResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRtcQualityMetricResponse
		var err error
		defer close(result)
		response, err = client.DescribeRtcQualityMetric(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRtcQualityMetricRequest is the request struct for api DescribeRtcQualityMetric
type DescribeRtcQualityMetricRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	SubUser   string           `position:"Query" name:"SubUser"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	PubUser   string           `position:"Query" name:"PubUser"`
	AppId     string           `position:"Query" name:"AppId"`
	ChannelId string           `position:"Query" name:"ChannelId"`
}

// DescribeRtcQualityMetricResponse is the response struct for api DescribeRtcQualityMetric
type DescribeRtcQualityMetricResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	QualityMetric QualityMetric `json:"QualityMetric" xml:"QualityMetric"`
}

// CreateDescribeRtcQualityMetricRequest creates a request to invoke DescribeRtcQualityMetric API
func CreateDescribeRtcQualityMetricRequest() (request *DescribeRtcQualityMetricRequest) {
	request = &DescribeRtcQualityMetricRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeRtcQualityMetric", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRtcQualityMetricResponse creates a response to parse from DescribeRtcQualityMetric response
func CreateDescribeRtcQualityMetricResponse() (response *DescribeRtcQualityMetricResponse) {
	response = &DescribeRtcQualityMetricResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
