package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMPURule invokes the rtc.DescribeMPURule API synchronously
func (client *Client) DescribeMPURule(request *DescribeMPURuleRequest) (response *DescribeMPURuleResponse, err error) {
	response = CreateDescribeMPURuleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMPURuleWithChan invokes the rtc.DescribeMPURule API asynchronously
func (client *Client) DescribeMPURuleWithChan(request *DescribeMPURuleRequest) (<-chan *DescribeMPURuleResponse, <-chan error) {
	responseChan := make(chan *DescribeMPURuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMPURule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMPURuleWithCallback invokes the rtc.DescribeMPURule API asynchronously
func (client *Client) DescribeMPURuleWithCallback(request *DescribeMPURuleRequest, callback func(response *DescribeMPURuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMPURuleResponse
		var err error
		defer close(result)
		response, err = client.DescribeMPURule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMPURuleRequest is the request struct for api DescribeMPURule
type DescribeMPURuleRequest struct {
	*requests.RpcRequest
	ShowLog string           `position:"Query" name:"ShowLog"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	AppId   string           `position:"Query" name:"AppId"`
}

// DescribeMPURuleResponse is the response struct for api DescribeMPURule
type DescribeMPURuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Rules     []Rule `json:"Rules" xml:"Rules"`
}

// CreateDescribeMPURuleRequest creates a request to invoke DescribeMPURule API
func CreateDescribeMPURuleRequest() (request *DescribeMPURuleRequest) {
	request = &DescribeMPURuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeMPURule", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMPURuleResponse creates a response to parse from DescribeMPURule response
func CreateDescribeMPURuleResponse() (response *DescribeMPURuleResponse) {
	response = &DescribeMPURuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
