package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMPURule invokes the rtc.DeleteMPURule API synchronously
func (client *Client) DeleteMPURule(request *DeleteMPURuleRequest) (response *DeleteMPURuleResponse, err error) {
	response = CreateDeleteMPURuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMPURuleWithChan invokes the rtc.DeleteMPURule API asynchronously
func (client *Client) DeleteMPURuleWithChan(request *DeleteMPURuleRequest) (<-chan *DeleteMPURuleResponse, <-chan error) {
	responseChan := make(chan *DeleteMPURuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMPURule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMPURuleWithCallback invokes the rtc.DeleteMPURule API asynchronously
func (client *Client) DeleteMPURuleWithCallback(request *DeleteMPURuleRequest, callback func(response *DeleteMPURuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMPURuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteMPURule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMPURuleRequest is the request struct for api DeleteMPURule
type DeleteMPURuleRequest struct {
	*requests.RpcRequest
	ShowLog string           `position:"Query" name:"ShowLog"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	AppId   string           `position:"Query" name:"AppId"`
	RuleId  requests.Integer `position:"Query" name:"RuleId"`
}

// DeleteMPURuleResponse is the response struct for api DeleteMPURule
type DeleteMPURuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteMPURuleRequest creates a request to invoke DeleteMPURule API
func CreateDeleteMPURuleRequest() (request *DeleteMPURuleRequest) {
	request = &DeleteMPURuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DeleteMPURule", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteMPURuleResponse creates a response to parse from DeleteMPURule response
func CreateDeleteMPURuleResponse() (response *DeleteMPURuleResponse) {
	response = &DeleteMPURuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
