package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMPULayout invokes the rtc.DeleteMPULayout API synchronously
func (client *Client) DeleteMPULayout(request *DeleteMPULayoutRequest) (response *DeleteMPULayoutResponse, err error) {
	response = CreateDeleteMPULayoutResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMPULayoutWithChan invokes the rtc.DeleteMPULayout API asynchronously
func (client *Client) DeleteMPULayoutWithChan(request *DeleteMPULayoutRequest) (<-chan *DeleteMPULayoutResponse, <-chan error) {
	responseChan := make(chan *DeleteMPULayoutResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMPULayout(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMPULayoutWithCallback invokes the rtc.DeleteMPULayout API asynchronously
func (client *Client) DeleteMPULayoutWithCallback(request *DeleteMPULayoutRequest, callback func(response *DeleteMPULayoutResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMPULayoutResponse
		var err error
		defer close(result)
		response, err = client.DeleteMPULayout(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMPULayoutRequest is the request struct for api DeleteMPULayout
type DeleteMPULayoutRequest struct {
	*requests.RpcRequest
	LayoutId requests.Integer `position:"Query" name:"LayoutId"`
	ShowLog  string           `position:"Query" name:"ShowLog"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	AppId    string           `position:"Query" name:"AppId"`
}

// DeleteMPULayoutResponse is the response struct for api DeleteMPULayout
type DeleteMPULayoutResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteMPULayoutRequest creates a request to invoke DeleteMPULayout API
func CreateDeleteMPULayoutRequest() (request *DeleteMPULayoutRequest) {
	request = &DeleteMPULayoutRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DeleteMPULayout", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteMPULayoutResponse creates a response to parse from DeleteMPULayout response
func CreateDeleteMPULayoutResponse() (response *DeleteMPULayoutResponse) {
	response = &DeleteMPULayoutResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
