package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResourceStatusNotify invokes the retailcloud.ResourceStatusNotify API synchronously
func (client *Client) ResourceStatusNotify(request *ResourceStatusNotifyRequest) (response *ResourceStatusNotifyResponse, err error) {
	response = CreateResourceStatusNotifyResponse()
	err = client.DoAction(request, response)
	return
}

// ResourceStatusNotifyWithChan invokes the retailcloud.ResourceStatusNotify API asynchronously
func (client *Client) ResourceStatusNotifyWithChan(request *ResourceStatusNotifyRequest) (<-chan *ResourceStatusNotifyResponse, <-chan error) {
	responseChan := make(chan *ResourceStatusNotifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResourceStatusNotify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResourceStatusNotifyWithCallback invokes the retailcloud.ResourceStatusNotify API asynchronously
func (client *Client) ResourceStatusNotifyWithCallback(request *ResourceStatusNotifyRequest, callback func(response *ResourceStatusNotifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResourceStatusNotifyResponse
		var err error
		defer close(result)
		response, err = client.ResourceStatusNotify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResourceStatusNotifyRequest is the request struct for api ResourceStatusNotify
type ResourceStatusNotifyRequest struct {
	*requests.RpcRequest
	Data string `position:"Body" name:"data"`
}

// ResourceStatusNotifyResponse is the response struct for api ResourceStatusNotify
type ResourceStatusNotifyResponse struct {
	*responses.BaseResponse
}

// CreateResourceStatusNotifyRequest creates a request to invoke ResourceStatusNotify API
func CreateResourceStatusNotifyRequest() (request *ResourceStatusNotifyRequest) {
	request = &ResourceStatusNotifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "ResourceStatusNotify", "", "")
	request.Method = requests.POST
	return
}

// CreateResourceStatusNotifyResponse creates a response to parse from ResourceStatusNotify response
func CreateResourceStatusNotifyResponse() (response *ResourceStatusNotifyResponse) {
	response = &ResourceStatusNotifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
