package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSyncResult invokes the qualitycheck.GetSyncResult API synchronously
func (client *Client) GetSyncResult(request *GetSyncResultRequest) (response *GetSyncResultResponse, err error) {
	response = CreateGetSyncResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetSyncResultWithChan invokes the qualitycheck.GetSyncResult API asynchronously
func (client *Client) GetSyncResultWithChan(request *GetSyncResultRequest) (<-chan *GetSyncResultResponse, <-chan error) {
	responseChan := make(chan *GetSyncResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSyncResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSyncResultWithCallback invokes the qualitycheck.GetSyncResult API asynchronously
func (client *Client) GetSyncResultWithCallback(request *GetSyncResultRequest, callback func(response *GetSyncResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSyncResultResponse
		var err error
		defer close(result)
		response, err = client.GetSyncResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSyncResultRequest is the request struct for api GetSyncResult
type GetSyncResultRequest struct {
	*requests.RpcRequest
	JsonStr string `position:"Query" name:"JsonStr"`
}

// GetSyncResultResponse is the response struct for api GetSyncResult
type GetSyncResultResponse struct {
	*responses.BaseResponse
	RequestId     string                      `json:"RequestId" xml:"RequestId"`
	Success       bool                        `json:"Success" xml:"Success"`
	Code          string                      `json:"Code" xml:"Code"`
	Message       string                      `json:"Message" xml:"Message"`
	Count         int                         `json:"Count" xml:"Count"`
	PageSize      int                         `json:"PageSize" xml:"PageSize"`
	PageNumber    int                         `json:"PageNumber" xml:"PageNumber"`
	ResultCountId string                      `json:"ResultCountId" xml:"ResultCountId"`
	Data          []ResultInfoInGetSyncResult `json:"Data" xml:"Data"`
}

// CreateGetSyncResultRequest creates a request to invoke GetSyncResult API
func CreateGetSyncResultRequest() (request *GetSyncResultRequest) {
	request = &GetSyncResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "GetSyncResult", "", "")
	request.Method = requests.POST
	return
}

// CreateGetSyncResultResponse creates a response to parse from GetSyncResult response
func CreateGetSyncResultResponse() (response *GetSyncResultResponse) {
	response = &GetSyncResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
