package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetResultCallback invokes the qualitycheck.GetResultCallback API synchronously
func (client *Client) GetResultCallback(request *GetResultCallbackRequest) (response *GetResultCallbackResponse, err error) {
	response = CreateGetResultCallbackResponse()
	err = client.DoAction(request, response)
	return
}

// GetResultCallbackWithChan invokes the qualitycheck.GetResultCallback API asynchronously
func (client *Client) GetResultCallbackWithChan(request *GetResultCallbackRequest) (<-chan *GetResultCallbackResponse, <-chan error) {
	responseChan := make(chan *GetResultCallbackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetResultCallback(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetResultCallbackWithCallback invokes the qualitycheck.GetResultCallback API asynchronously
func (client *Client) GetResultCallbackWithCallback(request *GetResultCallbackRequest, callback func(response *GetResultCallbackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetResultCallbackResponse
		var err error
		defer close(result)
		response, err = client.GetResultCallback(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetResultCallbackRequest is the request struct for api GetResultCallback
type GetResultCallbackRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// GetResultCallbackResponse is the response struct for api GetResultCallback
type GetResultCallbackResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateGetResultCallbackRequest creates a request to invoke GetResultCallback API
func CreateGetResultCallbackRequest() (request *GetResultCallbackRequest) {
	request = &GetResultCallbackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "GetResultCallback", "", "")
	request.Method = requests.POST
	return
}

// CreateGetResultCallbackResponse creates a response to parse from GetResultCallback response
func CreateGetResultCallbackResponse() (response *GetResultCallbackResponse) {
	response = &GetResultCallbackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
