package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBusinessCategoryList invokes the qualitycheck.GetBusinessCategoryList API synchronously
func (client *Client) GetBusinessCategoryList(request *GetBusinessCategoryListRequest) (response *GetBusinessCategoryListResponse, err error) {
	response = CreateGetBusinessCategoryListResponse()
	err = client.DoAction(request, response)
	return
}

// GetBusinessCategoryListWithChan invokes the qualitycheck.GetBusinessCategoryList API asynchronously
func (client *Client) GetBusinessCategoryListWithChan(request *GetBusinessCategoryListRequest) (<-chan *GetBusinessCategoryListResponse, <-chan error) {
	responseChan := make(chan *GetBusinessCategoryListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBusinessCategoryList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBusinessCategoryListWithCallback invokes the qualitycheck.GetBusinessCategoryList API asynchronously
func (client *Client) GetBusinessCategoryListWithCallback(request *GetBusinessCategoryListRequest, callback func(response *GetBusinessCategoryListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBusinessCategoryListResponse
		var err error
		defer close(result)
		response, err = client.GetBusinessCategoryList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBusinessCategoryListRequest is the request struct for api GetBusinessCategoryList
type GetBusinessCategoryListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// GetBusinessCategoryListResponse is the response struct for api GetBusinessCategoryList
type GetBusinessCategoryListResponse struct {
	*responses.BaseResponse
	RequestId string                        `json:"RequestId" xml:"RequestId"`
	Success   bool                          `json:"Success" xml:"Success"`
	Code      string                        `json:"Code" xml:"Code"`
	Message   string                        `json:"Message" xml:"Message"`
	Data      DataInGetBusinessCategoryList `json:"Data" xml:"Data"`
}

// CreateGetBusinessCategoryListRequest creates a request to invoke GetBusinessCategoryList API
func CreateGetBusinessCategoryListRequest() (request *GetBusinessCategoryListRequest) {
	request = &GetBusinessCategoryListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "GetBusinessCategoryList", "", "")
	request.Method = requests.POST
	return
}

// CreateGetBusinessCategoryListResponse creates a response to parse from GetBusinessCategoryList response
func CreateGetBusinessCategoryListResponse() (response *GetBusinessCategoryListResponse) {
	response = &GetBusinessCategoryListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
