package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDBNodes invokes the polardb.CreateDBNodes API synchronously
func (client *Client) CreateDBNodes(request *CreateDBNodesRequest) (response *CreateDBNodesResponse, err error) {
	response = CreateCreateDBNodesResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDBNodesWithChan invokes the polardb.CreateDBNodes API asynchronously
func (client *Client) CreateDBNodesWithChan(request *CreateDBNodesRequest) (<-chan *CreateDBNodesResponse, <-chan error) {
	responseChan := make(chan *CreateDBNodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDBNodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDBNodesWithCallback invokes the polardb.CreateDBNodes API asynchronously
func (client *Client) CreateDBNodesWithCallback(request *CreateDBNodesRequest, callback func(response *CreateDBNodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDBNodesResponse
		var err error
		defer close(result)
		response, err = client.CreateDBNodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDBNodesRequest is the request struct for api CreateDBNodes
type CreateDBNodesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer       `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string                 `position:"Query" name:"ClientToken"`
	EndpointBindList     string                 `position:"Query" name:"EndpointBindList"`
	PlannedEndTime       string                 `position:"Query" name:"PlannedEndTime"`
	ResourceOwnerAccount string                 `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string                 `position:"Query" name:"DBClusterId"`
	OwnerAccount         string                 `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer       `position:"Query" name:"OwnerId"`
	PlannedStartTime     string                 `position:"Query" name:"PlannedStartTime"`
	DBNode               *[]CreateDBNodesDBNode `position:"Query" name:"DBNode"  type:"Repeated"`
}

// CreateDBNodesDBNode is a repeated param struct in CreateDBNodesRequest
type CreateDBNodesDBNode struct {
	TargetClass string `name:"TargetClass"`
	ZoneId      string `name:"ZoneId"`
}

// CreateDBNodesResponse is the response struct for api CreateDBNodes
type CreateDBNodesResponse struct {
	*responses.BaseResponse
	RequestId   string                   `json:"RequestId" xml:"RequestId"`
	DBClusterId string                   `json:"DBClusterId" xml:"DBClusterId"`
	OrderId     string                   `json:"OrderId" xml:"OrderId"`
	DBNodeIds   DBNodeIdsInCreateDBNodes `json:"DBNodeIds" xml:"DBNodeIds"`
}

// CreateCreateDBNodesRequest creates a request to invoke CreateDBNodes API
func CreateCreateDBNodesRequest() (request *CreateDBNodesRequest) {
	request = &CreateDBNodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "CreateDBNodes", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDBNodesResponse creates a response to parse from CreateDBNodes response
func CreateCreateDBNodesResponse() (response *CreateDBNodesResponse) {
	response = &CreateDBNodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
