package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportScript invokes the outboundbot.ExportScript API synchronously
func (client *Client) ExportScript(request *ExportScriptRequest) (response *ExportScriptResponse, err error) {
	response = CreateExportScriptResponse()
	err = client.DoAction(request, response)
	return
}

// ExportScriptWithChan invokes the outboundbot.ExportScript API asynchronously
func (client *Client) ExportScriptWithChan(request *ExportScriptRequest) (<-chan *ExportScriptResponse, <-chan error) {
	responseChan := make(chan *ExportScriptResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportScript(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportScriptWithCallback invokes the outboundbot.ExportScript API asynchronously
func (client *Client) ExportScriptWithCallback(request *ExportScriptRequest, callback func(response *ExportScriptResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportScriptResponse
		var err error
		defer close(result)
		response, err = client.ExportScript(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportScriptRequest is the request struct for api ExportScript
type ExportScriptRequest struct {
	*requests.RpcRequest
	ScriptId   string `position:"Query" name:"ScriptId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ExportScriptResponse is the response struct for api ExportScript
type ExportScriptResponse struct {
	*responses.BaseResponse
	Code           string         `json:"Code" xml:"Code"`
	HttpStatusCode int            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string         `json:"Message" xml:"Message"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	DownloadParams DownloadParams `json:"DownloadParams" xml:"DownloadParams"`
}

// CreateExportScriptRequest creates a request to invoke ExportScript API
func CreateExportScriptRequest() (request *ExportScriptRequest) {
	request = &ExportScriptRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "ExportScript", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExportScriptResponse creates a response to parse from ExportScript response
func CreateExportScriptResponse() (response *ExportScriptResponse) {
	response = &ExportScriptResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
