package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSecondRanks invokes the opensearch.ListSecondRanks API synchronously
func (client *Client) ListSecondRanks(request *ListSecondRanksRequest) (response *ListSecondRanksResponse, err error) {
	response = CreateListSecondRanksResponse()
	err = client.DoAction(request, response)
	return
}

// ListSecondRanksWithChan invokes the opensearch.ListSecondRanks API asynchronously
func (client *Client) ListSecondRanksWithChan(request *ListSecondRanksRequest) (<-chan *ListSecondRanksResponse, <-chan error) {
	responseChan := make(chan *ListSecondRanksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSecondRanks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSecondRanksWithCallback invokes the opensearch.ListSecondRanks API asynchronously
func (client *Client) ListSecondRanksWithCallback(request *ListSecondRanksRequest, callback func(response *ListSecondRanksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSecondRanksResponse
		var err error
		defer close(result)
		response, err = client.ListSecondRanks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSecondRanksRequest is the request struct for api ListSecondRanks
type ListSecondRanksRequest struct {
	*requests.RoaRequest
	AppId            requests.Integer `position:"Path" name:"appId"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// ListSecondRanksResponse is the response struct for api ListSecondRanks
type ListSecondRanksResponse struct {
	*responses.BaseResponse
	RequestId  string       `json:"requestId" xml:"requestId"`
	TotalCount int          `json:"totalCount" xml:"totalCount"`
	Result     []ResultItem `json:"result" xml:"result"`
}

// CreateListSecondRanksRequest creates a request to invoke ListSecondRanks API
func CreateListSecondRanksRequest() (request *ListSecondRanksRequest) {
	request = &ListSecondRanksRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListSecondRanks", "/v4/openapi/app-groups/[appGroupIdentity]/apps/[appId]/second-ranks", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListSecondRanksResponse creates a response to parse from ListSecondRanks response
func CreateListSecondRanksResponse() (response *ListSecondRanksResponse) {
	response = &ListSecondRanksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
