package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelQueryById invokes the openanalytics_open.CancelQueryById API synchronously
func (client *Client) CancelQueryById(request *CancelQueryByIdRequest) (response *CancelQueryByIdResponse, err error) {
	response = CreateCancelQueryByIdResponse()
	err = client.DoAction(request, response)
	return
}

// CancelQueryByIdWithChan invokes the openanalytics_open.CancelQueryById API asynchronously
func (client *Client) CancelQueryByIdWithChan(request *CancelQueryByIdRequest) (<-chan *CancelQueryByIdResponse, <-chan error) {
	responseChan := make(chan *CancelQueryByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelQueryById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelQueryByIdWithCallback invokes the openanalytics_open.CancelQueryById API asynchronously
func (client *Client) CancelQueryByIdWithCallback(request *CancelQueryByIdRequest, callback func(response *CancelQueryByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelQueryByIdResponse
		var err error
		defer close(result)
		response, err = client.CancelQueryById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelQueryByIdRequest is the request struct for api CancelQueryById
type CancelQueryByIdRequest struct {
	*requests.RpcRequest
	QueryId string `position:"Body" name:"QueryId"`
}

// CancelQueryByIdResponse is the response struct for api CancelQueryById
type CancelQueryByIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RegionId  string `json:"RegionId" xml:"RegionId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateCancelQueryByIdRequest creates a request to invoke CancelQueryById API
func CreateCancelQueryByIdRequest() (request *CancelQueryByIdRequest) {
	request = &CancelQueryByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2018-06-19", "CancelQueryById", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelQueryByIdResponse creates a response to parse from CancelQueryById response
func CreateCancelQueryByIdResponse() (response *CancelQueryByIdResponse) {
	response = &CancelQueryByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
