package multimediaai

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTemplate invokes the multimediaai.GetTemplate API synchronously
// api document: https://help.aliyun.com/api/multimediaai/gettemplate.html
func (client *Client) GetTemplate(request *GetTemplateRequest) (response *GetTemplateResponse, err error) {
	response = CreateGetTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// GetTemplateWithChan invokes the multimediaai.GetTemplate API asynchronously
// api document: https://help.aliyun.com/api/multimediaai/gettemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTemplateWithChan(request *GetTemplateRequest) (<-chan *GetTemplateResponse, <-chan error) {
	responseChan := make(chan *GetTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTemplateWithCallback invokes the multimediaai.GetTemplate API asynchronously
// api document: https://help.aliyun.com/api/multimediaai/gettemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTemplateWithCallback(request *GetTemplateRequest, callback func(response *GetTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTemplateResponse
		var err error
		defer close(result)
		response, err = client.GetTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTemplateRequest is the request struct for api GetTemplate
type GetTemplateRequest struct {
	*requests.RpcRequest
	TemplateId requests.Integer `position:"Query" name:"TemplateId"`
}

// GetTemplateResponse is the response struct for api GetTemplate
type GetTemplateResponse struct {
	*responses.BaseResponse
	RequestId    string                 `json:"RequestId" xml:"RequestId"`
	TemplateId   string                 `json:"TemplateId" xml:"TemplateId"`
	TemplateName string                 `json:"TemplateName" xml:"TemplateName"`
	Content      map[string]interface{} `json:"Content" xml:"Content"`
	Category     int                    `json:"Category" xml:"Category"`
	IsDefault    bool                   `json:"IsDefault" xml:"IsDefault"`
	CreateTime   string                 `json:"CreateTime" xml:"CreateTime"`
	UpdateTime   string                 `json:"UpdateTime" xml:"UpdateTime"`
}

// CreateGetTemplateRequest creates a request to invoke GetTemplate API
func CreateGetTemplateRequest() (request *GetTemplateRequest) {
	request = &GetTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("multimediaai", "2019-08-10", "GetTemplate", "", "")
	request.Method = requests.POST
	return
}

// CreateGetTemplateResponse creates a response to parse from GetTemplate response
func CreateGetTemplateResponse() (response *GetTemplateResponse) {
	response = &GetTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
