package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSmarttagTemplate invokes the mts.UpdateSmarttagTemplate API synchronously
func (client *Client) UpdateSmarttagTemplate(request *UpdateSmarttagTemplateRequest) (response *UpdateSmarttagTemplateResponse, err error) {
	response = CreateUpdateSmarttagTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSmarttagTemplateWithChan invokes the mts.UpdateSmarttagTemplate API asynchronously
func (client *Client) UpdateSmarttagTemplateWithChan(request *UpdateSmarttagTemplateRequest) (<-chan *UpdateSmarttagTemplateResponse, <-chan error) {
	responseChan := make(chan *UpdateSmarttagTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSmarttagTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSmarttagTemplateWithCallback invokes the mts.UpdateSmarttagTemplate API asynchronously
func (client *Client) UpdateSmarttagTemplateWithCallback(request *UpdateSmarttagTemplateRequest, callback func(response *UpdateSmarttagTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSmarttagTemplateResponse
		var err error
		defer close(result)
		response, err = client.UpdateSmarttagTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSmarttagTemplateRequest is the request struct for api UpdateSmarttagTemplate
type UpdateSmarttagTemplateRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Industry             string           `position:"Query" name:"Industry"`
	Scene                string           `position:"Query" name:"Scene"`
	TemplateName         string           `position:"Query" name:"TemplateName"`
	IsDefault            requests.Boolean `position:"Query" name:"IsDefault"`
	FaceCategoryIds      string           `position:"Query" name:"FaceCategoryIds"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TemplateId           string           `position:"Query" name:"TemplateId"`
	AnalyseTypes         string           `position:"Query" name:"AnalyseTypes"`
}

// UpdateSmarttagTemplateResponse is the response struct for api UpdateSmarttagTemplate
type UpdateSmarttagTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateSmarttagTemplateRequest creates a request to invoke UpdateSmarttagTemplate API
func CreateUpdateSmarttagTemplateRequest() (request *UpdateSmarttagTemplateRequest) {
	request = &UpdateSmarttagTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "UpdateSmarttagTemplate", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateSmarttagTemplateResponse creates a response to parse from UpdateSmarttagTemplate response
func CreateUpdateSmarttagTemplateResponse() (response *UpdateSmarttagTemplateResponse) {
	response = &UpdateSmarttagTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
