package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRoamingJoinPermission invokes the linkwan.UpdateRoamingJoinPermission API synchronously
func (client *Client) UpdateRoamingJoinPermission(request *UpdateRoamingJoinPermissionRequest) (response *UpdateRoamingJoinPermissionResponse, err error) {
	response = CreateUpdateRoamingJoinPermissionResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRoamingJoinPermissionWithChan invokes the linkwan.UpdateRoamingJoinPermission API asynchronously
func (client *Client) UpdateRoamingJoinPermissionWithChan(request *UpdateRoamingJoinPermissionRequest) (<-chan *UpdateRoamingJoinPermissionResponse, <-chan error) {
	responseChan := make(chan *UpdateRoamingJoinPermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRoamingJoinPermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRoamingJoinPermissionWithCallback invokes the linkwan.UpdateRoamingJoinPermission API asynchronously
func (client *Client) UpdateRoamingJoinPermissionWithCallback(request *UpdateRoamingJoinPermissionRequest, callback func(response *UpdateRoamingJoinPermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRoamingJoinPermissionResponse
		var err error
		defer close(result)
		response, err = client.UpdateRoamingJoinPermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRoamingJoinPermissionRequest is the request struct for api UpdateRoamingJoinPermission
type UpdateRoamingJoinPermissionRequest struct {
	*requests.RpcRequest
	RxDelay            string `position:"Query" name:"RxDelay"`
	JoinPermissionId   string `position:"Query" name:"JoinPermissionId"`
	ApiProduct         string `position:"Body" name:"ApiProduct"`
	ApiRevision        string `position:"Body" name:"ApiRevision"`
	JoinPermissionName string `position:"Query" name:"JoinPermissionName"`
	DataRate           string `position:"Query" name:"DataRate"`
}

// UpdateRoamingJoinPermissionResponse is the response struct for api UpdateRoamingJoinPermission
type UpdateRoamingJoinPermissionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateRoamingJoinPermissionRequest creates a request to invoke UpdateRoamingJoinPermission API
func CreateUpdateRoamingJoinPermissionRequest() (request *UpdateRoamingJoinPermissionRequest) {
	request = &UpdateRoamingJoinPermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "UpdateRoamingJoinPermission", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateRoamingJoinPermissionResponse creates a response to parse from UpdateRoamingJoinPermission response
func CreateUpdateRoamingJoinPermissionResponse() (response *UpdateRoamingJoinPermissionResponse) {
	response = &UpdateRoamingJoinPermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
