package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNodeLocalConfig invokes the linkwan.GetNodeLocalConfig API synchronously
func (client *Client) GetNodeLocalConfig(request *GetNodeLocalConfigRequest) (response *GetNodeLocalConfigResponse, err error) {
	response = CreateGetNodeLocalConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetNodeLocalConfigWithChan invokes the linkwan.GetNodeLocalConfig API asynchronously
func (client *Client) GetNodeLocalConfigWithChan(request *GetNodeLocalConfigRequest) (<-chan *GetNodeLocalConfigResponse, <-chan error) {
	responseChan := make(chan *GetNodeLocalConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNodeLocalConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNodeLocalConfigWithCallback invokes the linkwan.GetNodeLocalConfig API asynchronously
func (client *Client) GetNodeLocalConfigWithCallback(request *GetNodeLocalConfigRequest, callback func(response *GetNodeLocalConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNodeLocalConfigResponse
		var err error
		defer close(result)
		response, err = client.GetNodeLocalConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNodeLocalConfigRequest is the request struct for api GetNodeLocalConfig
type GetNodeLocalConfigRequest struct {
	*requests.RpcRequest
	DevEui      string `position:"Query" name:"DevEui"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// GetNodeLocalConfigResponse is the response struct for api GetNodeLocalConfig
type GetNodeLocalConfigResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateGetNodeLocalConfigRequest creates a request to invoke GetNodeLocalConfig API
func CreateGetNodeLocalConfigRequest() (request *GetNodeLocalConfigRequest) {
	request = &GetNodeLocalConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "GetNodeLocalConfig", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetNodeLocalConfigResponse creates a response to parse from GetNodeLocalConfig response
func CreateGetNodeLocalConfigResponse() (response *GetNodeLocalConfigResponse) {
	response = &GetNodeLocalConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
