package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetupStudioAppAuthModeOpen invokes the iot.SetupStudioAppAuthModeOpen API synchronously
func (client *Client) SetupStudioAppAuthModeOpen(request *SetupStudioAppAuthModeOpenRequest) (response *SetupStudioAppAuthModeOpenResponse, err error) {
	response = CreateSetupStudioAppAuthModeOpenResponse()
	err = client.DoAction(request, response)
	return
}

// SetupStudioAppAuthModeOpenWithChan invokes the iot.SetupStudioAppAuthModeOpen API asynchronously
func (client *Client) SetupStudioAppAuthModeOpenWithChan(request *SetupStudioAppAuthModeOpenRequest) (<-chan *SetupStudioAppAuthModeOpenResponse, <-chan error) {
	responseChan := make(chan *SetupStudioAppAuthModeOpenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetupStudioAppAuthModeOpen(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetupStudioAppAuthModeOpenWithCallback invokes the iot.SetupStudioAppAuthModeOpen API asynchronously
func (client *Client) SetupStudioAppAuthModeOpenWithCallback(request *SetupStudioAppAuthModeOpenRequest, callback func(response *SetupStudioAppAuthModeOpenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetupStudioAppAuthModeOpenResponse
		var err error
		defer close(result)
		response, err = client.SetupStudioAppAuthModeOpen(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetupStudioAppAuthModeOpenRequest is the request struct for api SetupStudioAppAuthModeOpen
type SetupStudioAppAuthModeOpenRequest struct {
	*requests.RpcRequest
	IotInstanceId string           `position:"Body" name:"IotInstanceId"`
	ProjectId     string           `position:"Body" name:"ProjectId"`
	AuthMode      requests.Integer `position:"Body" name:"AuthMode"`
	AppId         string           `position:"Body" name:"AppId"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// SetupStudioAppAuthModeOpenResponse is the response struct for api SetupStudioAppAuthModeOpen
type SetupStudioAppAuthModeOpenResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateSetupStudioAppAuthModeOpenRequest creates a request to invoke SetupStudioAppAuthModeOpen API
func CreateSetupStudioAppAuthModeOpenRequest() (request *SetupStudioAppAuthModeOpenRequest) {
	request = &SetupStudioAppAuthModeOpenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "SetupStudioAppAuthModeOpen", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetupStudioAppAuthModeOpenResponse creates a response to parse from SetupStudioAppAuthModeOpen response
func CreateSetupStudioAppAuthModeOpenResponse() (response *SetupStudioAppAuthModeOpenResponse) {
	response = &SetupStudioAppAuthModeOpenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
