package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PushSpeech invokes the iot.PushSpeech API synchronously
func (client *Client) PushSpeech(request *PushSpeechRequest) (response *PushSpeechResponse, err error) {
	response = CreatePushSpeechResponse()
	err = client.DoAction(request, response)
	return
}

// PushSpeechWithChan invokes the iot.PushSpeech API asynchronously
func (client *Client) PushSpeechWithChan(request *PushSpeechRequest) (<-chan *PushSpeechResponse, <-chan error) {
	responseChan := make(chan *PushSpeechResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PushSpeech(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PushSpeechWithCallback invokes the iot.PushSpeech API asynchronously
func (client *Client) PushSpeechWithCallback(request *PushSpeechRequest, callback func(response *PushSpeechResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PushSpeechResponse
		var err error
		defer close(result)
		response, err = client.PushSpeech(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PushSpeechRequest is the request struct for api PushSpeech
type PushSpeechRequest struct {
	*requests.RpcRequest
	ProjectCode    string    `position:"Body" name:"ProjectCode"`
	IotId          string    `position:"Body" name:"IotId"`
	IotInstanceId  string    `position:"Body" name:"IotInstanceId"`
	PushMode       string    `position:"Body" name:"PushMode"`
	GroupId        string    `position:"Query" name:"GroupId"`
	SpeechCodeList *[]string `position:"Body" name:"SpeechCodeList"  type:"Repeated"`
	ProductKey     string    `position:"Body" name:"ProductKey"`
	ApiProduct     string    `position:"Body" name:"ApiProduct"`
	ApiRevision    string    `position:"Body" name:"ApiRevision"`
	DeviceName     string    `position:"Body" name:"DeviceName"`
}

// PushSpeechResponse is the response struct for api PushSpeech
type PushSpeechResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         string `json:"Data" xml:"Data"`
}

// CreatePushSpeechRequest creates a request to invoke PushSpeech API
func CreatePushSpeechRequest() (request *PushSpeechRequest) {
	request = &PushSpeechRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "PushSpeech", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePushSpeechResponse creates a response to parse from PushSpeech response
func CreatePushSpeechResponse() (response *PushSpeechResponse) {
	response = &PushSpeechResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
