package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBodyPerson invokes the facebody.ListBodyPerson API synchronously
func (client *Client) ListBodyPerson(request *ListBodyPersonRequest) (response *ListBodyPersonResponse, err error) {
	response = CreateListBodyPersonResponse()
	err = client.DoAction(request, response)
	return
}

// ListBodyPersonWithChan invokes the facebody.ListBodyPerson API asynchronously
func (client *Client) ListBodyPersonWithChan(request *ListBodyPersonRequest) (<-chan *ListBodyPersonResponse, <-chan error) {
	responseChan := make(chan *ListBodyPersonResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBodyPerson(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBodyPersonWithCallback invokes the facebody.ListBodyPerson API asynchronously
func (client *Client) ListBodyPersonWithCallback(request *ListBodyPersonRequest, callback func(response *ListBodyPersonResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBodyPersonResponse
		var err error
		defer close(result)
		response, err = client.ListBodyPerson(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBodyPersonRequest is the request struct for api ListBodyPerson
type ListBodyPersonRequest struct {
	*requests.RpcRequest
	Limit  requests.Integer `position:"Query" name:"Limit"`
	Offset requests.Integer `position:"Query" name:"Offset"`
	DbId   requests.Integer `position:"Query" name:"DbId"`
}

// ListBodyPersonResponse is the response struct for api ListBodyPerson
type ListBodyPersonResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListBodyPersonRequest creates a request to invoke ListBodyPerson API
func CreateListBodyPersonRequest() (request *ListBodyPersonRequest) {
	request = &ListBodyPersonRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "ListBodyPerson", "", "")
	request.Method = requests.GET
	return
}

// CreateListBodyPersonResponse creates a response to parse from ListBodyPerson response
func CreateListBodyPersonResponse() (response *ListBodyPersonResponse) {
	response = &ListBodyPersonResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
