package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAlarms invokes the ess.DescribeAlarms API synchronously
func (client *Client) DescribeAlarms(request *DescribeAlarmsRequest) (response *DescribeAlarmsResponse, err error) {
	response = CreateDescribeAlarmsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAlarmsWithChan invokes the ess.DescribeAlarms API asynchronously
func (client *Client) DescribeAlarmsWithChan(request *DescribeAlarmsRequest) (<-chan *DescribeAlarmsResponse, <-chan error) {
	responseChan := make(chan *DescribeAlarmsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAlarms(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAlarmsWithCallback invokes the ess.DescribeAlarms API asynchronously
func (client *Client) DescribeAlarmsWithCallback(request *DescribeAlarmsRequest, callback func(response *DescribeAlarmsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAlarmsResponse
		var err error
		defer close(result)
		response, err = client.DescribeAlarms(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAlarmsRequest is the request struct for api DescribeAlarms
type DescribeAlarmsRequest struct {
	*requests.RpcRequest
	MetricType           string           `position:"Query" name:"MetricType"`
	ScalingGroupId       string           `position:"Query" name:"ScalingGroupId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	State                string           `position:"Query" name:"State"`
	MetricName           string           `position:"Query" name:"MetricName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	AlarmTaskId          string           `position:"Query" name:"AlarmTaskId"`
	IsEnable             requests.Boolean `position:"Query" name:"IsEnable"`
}

// DescribeAlarmsResponse is the response struct for api DescribeAlarms
type DescribeAlarmsResponse struct {
	*responses.BaseResponse
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	TotalCount int       `json:"TotalCount" xml:"TotalCount"`
	PageNumber int       `json:"PageNumber" xml:"PageNumber"`
	PageSize   int       `json:"PageSize" xml:"PageSize"`
	AlarmList  AlarmList `json:"AlarmList" xml:"AlarmList"`
}

// CreateDescribeAlarmsRequest creates a request to invoke DescribeAlarms API
func CreateDescribeAlarmsRequest() (request *DescribeAlarmsRequest) {
	request = &DescribeAlarmsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "DescribeAlarms", "ess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAlarmsResponse creates a response to parse from DescribeAlarms response
func CreateDescribeAlarmsResponse() (response *DescribeAlarmsResponse) {
	response = &DescribeAlarmsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
