package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEnsRegionIdResource invokes the ens.DescribeEnsRegionIdResource API synchronously
func (client *Client) DescribeEnsRegionIdResource(request *DescribeEnsRegionIdResourceRequest) (response *DescribeEnsRegionIdResourceResponse, err error) {
	response = CreateDescribeEnsRegionIdResourceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEnsRegionIdResourceWithChan invokes the ens.DescribeEnsRegionIdResource API asynchronously
func (client *Client) DescribeEnsRegionIdResourceWithChan(request *DescribeEnsRegionIdResourceRequest) (<-chan *DescribeEnsRegionIdResourceResponse, <-chan error) {
	responseChan := make(chan *DescribeEnsRegionIdResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEnsRegionIdResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEnsRegionIdResourceWithCallback invokes the ens.DescribeEnsRegionIdResource API asynchronously
func (client *Client) DescribeEnsRegionIdResourceWithCallback(request *DescribeEnsRegionIdResourceRequest, callback func(response *DescribeEnsRegionIdResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEnsRegionIdResourceResponse
		var err error
		defer close(result)
		response, err = client.DescribeEnsRegionIdResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEnsRegionIdResourceRequest is the request struct for api DescribeEnsRegionIdResource
type DescribeEnsRegionIdResourceRequest struct {
	*requests.RpcRequest
	Isp           string           `position:"Query" name:"Isp"`
	StartTime     string           `position:"Query" name:"StartTime"`
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	OrderByParams string           `position:"Query" name:"OrderByParams"`
	PageSize      string           `position:"Query" name:"PageSize"`
	EndTime       string           `position:"Query" name:"EndTime"`
}

// DescribeEnsRegionIdResourceResponse is the response struct for api DescribeEnsRegionIdResource
type DescribeEnsRegionIdResourceResponse struct {
	*responses.BaseResponse
	PageNumber           int                  `json:"PageNumber" xml:"PageNumber"`
	PageSize             int                  `json:"PageSize" xml:"PageSize"`
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	TotalCount           int                  `json:"TotalCount" xml:"TotalCount"`
	EnsRegionIdResources EnsRegionIdResources `json:"EnsRegionIdResources" xml:"EnsRegionIdResources"`
}

// CreateDescribeEnsRegionIdResourceRequest creates a request to invoke DescribeEnsRegionIdResource API
func CreateDescribeEnsRegionIdResourceRequest() (request *DescribeEnsRegionIdResourceRequest) {
	request = &DescribeEnsRegionIdResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeEnsRegionIdResource", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEnsRegionIdResourceResponse creates a response to parse from DescribeEnsRegionIdResource response
func CreateDescribeEnsRegionIdResourceResponse() (response *DescribeEnsRegionIdResourceResponse) {
	response = &DescribeEnsRegionIdResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
