package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApplicationResourceSummary invokes the ens.DescribeApplicationResourceSummary API synchronously
func (client *Client) DescribeApplicationResourceSummary(request *DescribeApplicationResourceSummaryRequest) (response *DescribeApplicationResourceSummaryResponse, err error) {
	response = CreateDescribeApplicationResourceSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeApplicationResourceSummaryWithChan invokes the ens.DescribeApplicationResourceSummary API asynchronously
func (client *Client) DescribeApplicationResourceSummaryWithChan(request *DescribeApplicationResourceSummaryRequest) (<-chan *DescribeApplicationResourceSummaryResponse, <-chan error) {
	responseChan := make(chan *DescribeApplicationResourceSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApplicationResourceSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeApplicationResourceSummaryWithCallback invokes the ens.DescribeApplicationResourceSummary API asynchronously
func (client *Client) DescribeApplicationResourceSummaryWithCallback(request *DescribeApplicationResourceSummaryRequest, callback func(response *DescribeApplicationResourceSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeApplicationResourceSummaryResponse
		var err error
		defer close(result)
		response, err = client.DescribeApplicationResourceSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeApplicationResourceSummaryRequest is the request struct for api DescribeApplicationResourceSummary
type DescribeApplicationResourceSummaryRequest struct {
	*requests.RpcRequest
	Level        string `position:"Query" name:"Level"`
	ResourceType string `position:"Query" name:"ResourceType"`
}

// DescribeApplicationResourceSummaryResponse is the response struct for api DescribeApplicationResourceSummary
type DescribeApplicationResourceSummaryResponse struct {
	*responses.BaseResponse
	ApplicationResource string `json:"ApplicationResource" xml:"ApplicationResource"`
	RequestId           string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeApplicationResourceSummaryRequest creates a request to invoke DescribeApplicationResourceSummary API
func CreateDescribeApplicationResourceSummaryRequest() (request *DescribeApplicationResourceSummaryRequest) {
	request = &DescribeApplicationResourceSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeApplicationResourceSummary", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeApplicationResourceSummaryResponse creates a response to parse from DescribeApplicationResourceSummary response
func CreateDescribeApplicationResourceSummaryResponse() (response *DescribeApplicationResourceSummaryResponse) {
	response = &DescribeApplicationResourceSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
