package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UninstallLibraries invokes the emr.UninstallLibraries API synchronously
func (client *Client) UninstallLibraries(request *UninstallLibrariesRequest) (response *UninstallLibrariesResponse, err error) {
	response = CreateUninstallLibrariesResponse()
	err = client.DoAction(request, response)
	return
}

// UninstallLibrariesWithChan invokes the emr.UninstallLibraries API asynchronously
func (client *Client) UninstallLibrariesWithChan(request *UninstallLibrariesRequest) (<-chan *UninstallLibrariesResponse, <-chan error) {
	responseChan := make(chan *UninstallLibrariesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UninstallLibraries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UninstallLibrariesWithCallback invokes the emr.UninstallLibraries API asynchronously
func (client *Client) UninstallLibrariesWithCallback(request *UninstallLibrariesRequest, callback func(response *UninstallLibrariesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UninstallLibrariesResponse
		var err error
		defer close(result)
		response, err = client.UninstallLibraries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UninstallLibrariesRequest is the request struct for api UninstallLibraries
type UninstallLibrariesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId  requests.Integer `position:"Query" name:"ResourceOwnerId"`
	LibraryBizId     string           `position:"Query" name:"LibraryBizId"`
	ClusterBizIdList *[]string        `position:"Query" name:"ClusterBizIdList"  type:"Repeated"`
}

// UninstallLibrariesResponse is the response struct for api UninstallLibraries
type UninstallLibrariesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateUninstallLibrariesRequest creates a request to invoke UninstallLibraries API
func CreateUninstallLibrariesRequest() (request *UninstallLibrariesRequest) {
	request = &UninstallLibrariesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "UninstallLibraries", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUninstallLibrariesResponse creates a response to parse from UninstallLibraries response
func CreateUninstallLibrariesResponse() (response *UninstallLibrariesResponse) {
	response = &UninstallLibrariesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
