package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyClusterMetaCollect invokes the emr.ModifyClusterMetaCollect API synchronously
func (client *Client) ModifyClusterMetaCollect(request *ModifyClusterMetaCollectRequest) (response *ModifyClusterMetaCollectResponse, err error) {
	response = CreateModifyClusterMetaCollectResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyClusterMetaCollectWithChan invokes the emr.ModifyClusterMetaCollect API asynchronously
func (client *Client) ModifyClusterMetaCollectWithChan(request *ModifyClusterMetaCollectRequest) (<-chan *ModifyClusterMetaCollectResponse, <-chan error) {
	responseChan := make(chan *ModifyClusterMetaCollectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyClusterMetaCollect(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyClusterMetaCollectWithCallback invokes the emr.ModifyClusterMetaCollect API asynchronously
func (client *Client) ModifyClusterMetaCollectWithCallback(request *ModifyClusterMetaCollectRequest, callback func(response *ModifyClusterMetaCollectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyClusterMetaCollectResponse
		var err error
		defer close(result)
		response, err = client.ModifyClusterMetaCollect(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyClusterMetaCollectRequest is the request struct for api ModifyClusterMetaCollect
type ModifyClusterMetaCollectRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	SwitchOn        requests.Boolean `position:"Query" name:"SwitchOn"`
}

// ModifyClusterMetaCollectResponse is the response struct for api ModifyClusterMetaCollect
type ModifyClusterMetaCollectResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyClusterMetaCollectRequest creates a request to invoke ModifyClusterMetaCollect API
func CreateModifyClusterMetaCollectRequest() (request *ModifyClusterMetaCollectRequest) {
	request = &ModifyClusterMetaCollectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyClusterMetaCollect", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyClusterMetaCollectResponse creates a response to parse from ModifyClusterMetaCollect response
func CreateModifyClusterMetaCollectResponse() (response *ModifyClusterMetaCollectResponse) {
	response = &ModifyClusterMetaCollectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
