package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InstallLibraries invokes the emr.InstallLibraries API synchronously
func (client *Client) InstallLibraries(request *InstallLibrariesRequest) (response *InstallLibrariesResponse, err error) {
	response = CreateInstallLibrariesResponse()
	err = client.DoAction(request, response)
	return
}

// InstallLibrariesWithChan invokes the emr.InstallLibraries API asynchronously
func (client *Client) InstallLibrariesWithChan(request *InstallLibrariesRequest) (<-chan *InstallLibrariesResponse, <-chan error) {
	responseChan := make(chan *InstallLibrariesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InstallLibraries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InstallLibrariesWithCallback invokes the emr.InstallLibraries API asynchronously
func (client *Client) InstallLibrariesWithCallback(request *InstallLibrariesRequest, callback func(response *InstallLibrariesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InstallLibrariesResponse
		var err error
		defer close(result)
		response, err = client.InstallLibraries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InstallLibrariesRequest is the request struct for api InstallLibraries
type InstallLibrariesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId  requests.Integer `position:"Query" name:"ResourceOwnerId"`
	LibraryBizId     string           `position:"Query" name:"LibraryBizId"`
	ClusterBizIdList *[]string        `position:"Query" name:"ClusterBizIdList"  type:"Repeated"`
}

// InstallLibrariesResponse is the response struct for api InstallLibraries
type InstallLibrariesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateInstallLibrariesRequest creates a request to invoke InstallLibraries API
func CreateInstallLibrariesRequest() (request *InstallLibrariesRequest) {
	request = &InstallLibrariesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "InstallLibraries", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInstallLibrariesResponse creates a response to parse from InstallLibraries response
func CreateInstallLibrariesResponse() (response *InstallLibrariesResponse) {
	response = &InstallLibrariesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
