package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLibraryDetail invokes the emr.DescribeLibraryDetail API synchronously
func (client *Client) DescribeLibraryDetail(request *DescribeLibraryDetailRequest) (response *DescribeLibraryDetailResponse, err error) {
	response = CreateDescribeLibraryDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLibraryDetailWithChan invokes the emr.DescribeLibraryDetail API asynchronously
func (client *Client) DescribeLibraryDetailWithChan(request *DescribeLibraryDetailRequest) (<-chan *DescribeLibraryDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeLibraryDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLibraryDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLibraryDetailWithCallback invokes the emr.DescribeLibraryDetail API asynchronously
func (client *Client) DescribeLibraryDetailWithCallback(request *DescribeLibraryDetailRequest, callback func(response *DescribeLibraryDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLibraryDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeLibraryDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLibraryDetailRequest is the request struct for api DescribeLibraryDetail
type DescribeLibraryDetailRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	LibraryBizId    string           `position:"Query" name:"LibraryBizId"`
}

// DescribeLibraryDetailResponse is the response struct for api DescribeLibraryDetail
type DescribeLibraryDetailResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	BizId          string `json:"BizId" xml:"BizId"`
	CreateTime     int64  `json:"CreateTime" xml:"CreateTime"`
	Type           string `json:"Type" xml:"Type"`
	Name           string `json:"Name" xml:"Name"`
	LibraryVersion string `json:"LibraryVersion" xml:"LibraryVersion"`
	SourceType     string `json:"SourceType" xml:"SourceType"`
	SourceLocation string `json:"SourceLocation" xml:"SourceLocation"`
	Scope          string `json:"Scope" xml:"Scope"`
	Properties     string `json:"Properties" xml:"Properties"`
	UserId         string `json:"UserId" xml:"UserId"`
}

// CreateDescribeLibraryDetailRequest creates a request to invoke DescribeLibraryDetail API
func CreateDescribeLibraryDetailRequest() (request *DescribeLibraryDetailRequest) {
	request = &DescribeLibraryDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeLibraryDetail", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLibraryDetailResponse creates a response to parse from DescribeLibraryDetail response
func CreateDescribeLibraryDetailResponse() (response *DescribeLibraryDetailResponse) {
	response = &DescribeLibraryDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
