package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDiagnoseIndices invokes the elasticsearch.ListDiagnoseIndices API synchronously
func (client *Client) ListDiagnoseIndices(request *ListDiagnoseIndicesRequest) (response *ListDiagnoseIndicesResponse, err error) {
	response = CreateListDiagnoseIndicesResponse()
	err = client.DoAction(request, response)
	return
}

// ListDiagnoseIndicesWithChan invokes the elasticsearch.ListDiagnoseIndices API asynchronously
func (client *Client) ListDiagnoseIndicesWithChan(request *ListDiagnoseIndicesRequest) (<-chan *ListDiagnoseIndicesResponse, <-chan error) {
	responseChan := make(chan *ListDiagnoseIndicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDiagnoseIndices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDiagnoseIndicesWithCallback invokes the elasticsearch.ListDiagnoseIndices API asynchronously
func (client *Client) ListDiagnoseIndicesWithCallback(request *ListDiagnoseIndicesRequest, callback func(response *ListDiagnoseIndicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDiagnoseIndicesResponse
		var err error
		defer close(result)
		response, err = client.ListDiagnoseIndices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDiagnoseIndicesRequest is the request struct for api ListDiagnoseIndices
type ListDiagnoseIndicesRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
	Lang       string `position:"Query" name:"lang"`
}

// ListDiagnoseIndicesResponse is the response struct for api ListDiagnoseIndices
type ListDiagnoseIndicesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Result    []string `json:"Result" xml:"Result"`
}

// CreateListDiagnoseIndicesRequest creates a request to invoke ListDiagnoseIndices API
func CreateListDiagnoseIndicesRequest() (request *ListDiagnoseIndicesRequest) {
	request = &ListDiagnoseIndicesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListDiagnoseIndices", "/openapi/diagnosis/instances/[InstanceId]/indices", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListDiagnoseIndicesResponse creates a response to parse from ListDiagnoseIndices response
func CreateListDiagnoseIndicesResponse() (response *ListDiagnoseIndicesResponse) {
	response = &ListDiagnoseIndicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
