package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryServiceTimeConfig invokes the edas.QueryServiceTimeConfig API synchronously
func (client *Client) QueryServiceTimeConfig(request *QueryServiceTimeConfigRequest) (response *QueryServiceTimeConfigResponse, err error) {
	response = CreateQueryServiceTimeConfigResponse()
	err = client.DoAction(request, response)
	return
}

// QueryServiceTimeConfigWithChan invokes the edas.QueryServiceTimeConfig API asynchronously
func (client *Client) QueryServiceTimeConfigWithChan(request *QueryServiceTimeConfigRequest) (<-chan *QueryServiceTimeConfigResponse, <-chan error) {
	responseChan := make(chan *QueryServiceTimeConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryServiceTimeConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryServiceTimeConfigWithCallback invokes the edas.QueryServiceTimeConfig API asynchronously
func (client *Client) QueryServiceTimeConfigWithCallback(request *QueryServiceTimeConfigRequest, callback func(response *QueryServiceTimeConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryServiceTimeConfigResponse
		var err error
		defer close(result)
		response, err = client.QueryServiceTimeConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryServiceTimeConfigRequest is the request struct for api QueryServiceTimeConfig
type QueryServiceTimeConfigRequest struct {
	*requests.RoaRequest
	ServiceType    string           `position:"Query" name:"ServiceType"`
	AppId          string           `position:"Query" name:"AppId"`
	ServiceVersion string           `position:"Query" name:"ServiceVersion"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	Namespace      string           `position:"Query" name:"Namespace"`
	ServiceName    string           `position:"Query" name:"ServiceName"`
	Source         string           `position:"Query" name:"Source"`
	Region         string           `position:"Query" name:"Region"`
	ServiceGroup   string           `position:"Query" name:"ServiceGroup"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
}

// QueryServiceTimeConfigResponse is the response struct for api QueryServiceTimeConfig
type QueryServiceTimeConfigResponse struct {
	*responses.BaseResponse
	Code    int                          `json:"Code" xml:"Code"`
	Message string                       `json:"Message" xml:"Message"`
	Success bool                         `json:"Success" xml:"Success"`
	Data    DataInQueryServiceTimeConfig `json:"Data" xml:"Data"`
}

// CreateQueryServiceTimeConfigRequest creates a request to invoke QueryServiceTimeConfig API
func CreateQueryServiceTimeConfigRequest() (request *QueryServiceTimeConfigRequest) {
	request = &QueryServiceTimeConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "QueryServiceTimeConfig", "/pop/sp/api/timeout/page", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryServiceTimeConfigResponse creates a response to parse from QueryServiceTimeConfig response
func CreateQueryServiceTimeConfigResponse() (response *QueryServiceTimeConfigResponse) {
	response = &QueryServiceTimeConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
