package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryEccInfo invokes the edas.QueryEccInfo API synchronously
func (client *Client) QueryEccInfo(request *QueryEccInfoRequest) (response *QueryEccInfoResponse, err error) {
	response = CreateQueryEccInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryEccInfoWithChan invokes the edas.QueryEccInfo API asynchronously
func (client *Client) QueryEccInfoWithChan(request *QueryEccInfoRequest) (<-chan *QueryEccInfoResponse, <-chan error) {
	responseChan := make(chan *QueryEccInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryEccInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryEccInfoWithCallback invokes the edas.QueryEccInfo API asynchronously
func (client *Client) QueryEccInfoWithCallback(request *QueryEccInfoRequest, callback func(response *QueryEccInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryEccInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryEccInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryEccInfoRequest is the request struct for api QueryEccInfo
type QueryEccInfoRequest struct {
	*requests.RoaRequest
	EccId string `position:"Query" name:"EccId"`
}

// QueryEccInfoResponse is the response struct for api QueryEccInfo
type QueryEccInfoResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	EccInfo   EccInfo `json:"EccInfo" xml:"EccInfo"`
}

// CreateQueryEccInfoRequest creates a request to invoke QueryEccInfo API
func CreateQueryEccInfoRequest() (request *QueryEccInfoRequest) {
	request = &QueryEccInfoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "QueryEccInfo", "/pop/v5/ecc", "edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateQueryEccInfoResponse creates a response to parse from QueryEccInfo response
func CreateQueryEccInfoResponse() (response *QueryEccInfoResponse) {
	response = &QueryEccInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
