package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InsertFlowControl invokes the edas.InsertFlowControl API synchronously
func (client *Client) InsertFlowControl(request *InsertFlowControlRequest) (response *InsertFlowControlResponse, err error) {
	response = CreateInsertFlowControlResponse()
	err = client.DoAction(request, response)
	return
}

// InsertFlowControlWithChan invokes the edas.InsertFlowControl API asynchronously
func (client *Client) InsertFlowControlWithChan(request *InsertFlowControlRequest) (<-chan *InsertFlowControlResponse, <-chan error) {
	responseChan := make(chan *InsertFlowControlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InsertFlowControl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InsertFlowControlWithCallback invokes the edas.InsertFlowControl API asynchronously
func (client *Client) InsertFlowControlWithCallback(request *InsertFlowControlRequest, callback func(response *InsertFlowControlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InsertFlowControlResponse
		var err error
		defer close(result)
		response, err = client.InsertFlowControl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InsertFlowControlRequest is the request struct for api InsertFlowControl
type InsertFlowControlRequest struct {
	*requests.RoaRequest
	ConsumerAppId string           `position:"Query" name:"ConsumerAppId"`
	Granularity   string           `position:"Query" name:"Granularity"`
	RuleType      string           `position:"Query" name:"RuleType"`
	AppId         string           `position:"Query" name:"AppId"`
	UrlVar        string           `position:"Query" name:"UrlVar"`
	ServiceName   string           `position:"Query" name:"ServiceName"`
	Threshold     requests.Integer `position:"Query" name:"Threshold"`
	Strategy      string           `position:"Query" name:"Strategy"`
	MethodName    string           `position:"Query" name:"MethodName"`
}

// InsertFlowControlResponse is the response struct for api InsertFlowControl
type InsertFlowControlResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateInsertFlowControlRequest creates a request to invoke InsertFlowControl API
func CreateInsertFlowControlRequest() (request *InsertFlowControlRequest) {
	request = &InsertFlowControlRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "InsertFlowControl", "/pop/v5/flowControl", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInsertFlowControlResponse creates a response to parse from InsertFlowControl response
func CreateInsertFlowControlResponse() (response *InsertFlowControlResponse) {
	response = &InsertFlowControlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
