package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMockRuleById invokes the edas.GetMockRuleById API synchronously
func (client *Client) GetMockRuleById(request *GetMockRuleByIdRequest) (response *GetMockRuleByIdResponse, err error) {
	response = CreateGetMockRuleByIdResponse()
	err = client.DoAction(request, response)
	return
}

// GetMockRuleByIdWithChan invokes the edas.GetMockRuleById API asynchronously
func (client *Client) GetMockRuleByIdWithChan(request *GetMockRuleByIdRequest) (<-chan *GetMockRuleByIdResponse, <-chan error) {
	responseChan := make(chan *GetMockRuleByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMockRuleById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMockRuleByIdWithCallback invokes the edas.GetMockRuleById API asynchronously
func (client *Client) GetMockRuleByIdWithCallback(request *GetMockRuleByIdRequest, callback func(response *GetMockRuleByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMockRuleByIdResponse
		var err error
		defer close(result)
		response, err = client.GetMockRuleById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMockRuleByIdRequest is the request struct for api GetMockRuleById
type GetMockRuleByIdRequest struct {
	*requests.RoaRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// GetMockRuleByIdResponse is the response struct for api GetMockRuleById
type GetMockRuleByIdResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetMockRuleByIdRequest creates a request to invoke GetMockRuleById API
func CreateGetMockRuleByIdRequest() (request *GetMockRuleByIdRequest) {
	request = &GetMockRuleByIdRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "GetMockRuleById", "/pop/sp/api/mock/getMockRuleById", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetMockRuleByIdResponse creates a response to parse from GetMockRuleById response
func CreateGetMockRuleByIdResponse() (response *GetMockRuleByIdResponse) {
	response = &GetMockRuleByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
