package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetApplication invokes the edas.GetApplication API synchronously
func (client *Client) GetApplication(request *GetApplicationRequest) (response *GetApplicationResponse, err error) {
	response = CreateGetApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// GetApplicationWithChan invokes the edas.GetApplication API asynchronously
func (client *Client) GetApplicationWithChan(request *GetApplicationRequest) (<-chan *GetApplicationResponse, <-chan error) {
	responseChan := make(chan *GetApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetApplicationWithCallback invokes the edas.GetApplication API asynchronously
func (client *Client) GetApplicationWithCallback(request *GetApplicationRequest, callback func(response *GetApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetApplicationResponse
		var err error
		defer close(result)
		response, err = client.GetApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetApplicationRequest is the request struct for api GetApplication
type GetApplicationRequest struct {
	*requests.RoaRequest
	AppId string `position:"Query" name:"AppId"`
}

// GetApplicationResponse is the response struct for api GetApplication
type GetApplicationResponse struct {
	*responses.BaseResponse
	Code        int         `json:"Code" xml:"Code"`
	Message     string      `json:"Message" xml:"Message"`
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	Applcation  Applcation  `json:"Applcation" xml:"Applcation"`
	Application Application `json:"Application" xml:"Application"`
}

// CreateGetApplicationRequest creates a request to invoke GetApplication API
func CreateGetApplicationRequest() (request *GetApplicationRequest) {
	request = &GetApplicationRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "GetApplication", "/pop/v5/app/app_info", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetApplicationResponse creates a response to parse from GetApplication response
func CreateGetApplicationResponse() (response *GetApplicationResponse) {
	response = &GetApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
