package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableDegradeControl invokes the edas.EnableDegradeControl API synchronously
func (client *Client) EnableDegradeControl(request *EnableDegradeControlRequest) (response *EnableDegradeControlResponse, err error) {
	response = CreateEnableDegradeControlResponse()
	err = client.DoAction(request, response)
	return
}

// EnableDegradeControlWithChan invokes the edas.EnableDegradeControl API asynchronously
func (client *Client) EnableDegradeControlWithChan(request *EnableDegradeControlRequest) (<-chan *EnableDegradeControlResponse, <-chan error) {
	responseChan := make(chan *EnableDegradeControlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableDegradeControl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableDegradeControlWithCallback invokes the edas.EnableDegradeControl API asynchronously
func (client *Client) EnableDegradeControlWithCallback(request *EnableDegradeControlRequest, callback func(response *EnableDegradeControlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableDegradeControlResponse
		var err error
		defer close(result)
		response, err = client.EnableDegradeControl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableDegradeControlRequest is the request struct for api EnableDegradeControl
type EnableDegradeControlRequest struct {
	*requests.RoaRequest
	AppId  string `position:"Query" name:"AppId"`
	RuleId string `position:"Query" name:"RuleId"`
}

// EnableDegradeControlResponse is the response struct for api EnableDegradeControl
type EnableDegradeControlResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableDegradeControlRequest creates a request to invoke EnableDegradeControl API
func CreateEnableDegradeControlRequest() (request *EnableDegradeControlRequest) {
	request = &EnableDegradeControlRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "EnableDegradeControl", "/pop/v5/degradecontrol/enable", "edas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateEnableDegradeControlResponse creates a response to parse from EnableDegradeControl response
func CreateEnableDegradeControlResponse() (response *EnableDegradeControlResponse) {
	response = &EnableDegradeControlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
