package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableMockRule invokes the edas.DisableMockRule API synchronously
func (client *Client) DisableMockRule(request *DisableMockRuleRequest) (response *DisableMockRuleResponse, err error) {
	response = CreateDisableMockRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DisableMockRuleWithChan invokes the edas.DisableMockRule API asynchronously
func (client *Client) DisableMockRuleWithChan(request *DisableMockRuleRequest) (<-chan *DisableMockRuleResponse, <-chan error) {
	responseChan := make(chan *DisableMockRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableMockRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableMockRuleWithCallback invokes the edas.DisableMockRule API asynchronously
func (client *Client) DisableMockRuleWithCallback(request *DisableMockRuleRequest, callback func(response *DisableMockRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableMockRuleResponse
		var err error
		defer close(result)
		response, err = client.DisableMockRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableMockRuleRequest is the request struct for api DisableMockRule
type DisableMockRuleRequest struct {
	*requests.RoaRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// DisableMockRuleResponse is the response struct for api DisableMockRule
type DisableMockRuleResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDisableMockRuleRequest creates a request to invoke DisableMockRule API
func CreateDisableMockRuleRequest() (request *DisableMockRuleRequest) {
	request = &DisableMockRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DisableMockRule", "/pop/sp/api/mock/disableMockRule", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableMockRuleResponse creates a response to parse from DisableMockRule response
func CreateDisableMockRuleResponse() (response *DisableMockRuleResponse) {
	response = &DisableMockRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
