package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEnvHsfTrafficControl invokes the edas.DeleteEnvHsfTrafficControl API synchronously
func (client *Client) DeleteEnvHsfTrafficControl(request *DeleteEnvHsfTrafficControlRequest) (response *DeleteEnvHsfTrafficControlResponse, err error) {
	response = CreateDeleteEnvHsfTrafficControlResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEnvHsfTrafficControlWithChan invokes the edas.DeleteEnvHsfTrafficControl API asynchronously
func (client *Client) DeleteEnvHsfTrafficControlWithChan(request *DeleteEnvHsfTrafficControlRequest) (<-chan *DeleteEnvHsfTrafficControlResponse, <-chan error) {
	responseChan := make(chan *DeleteEnvHsfTrafficControlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEnvHsfTrafficControl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEnvHsfTrafficControlWithCallback invokes the edas.DeleteEnvHsfTrafficControl API asynchronously
func (client *Client) DeleteEnvHsfTrafficControlWithCallback(request *DeleteEnvHsfTrafficControlRequest, callback func(response *DeleteEnvHsfTrafficControlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEnvHsfTrafficControlResponse
		var err error
		defer close(result)
		response, err = client.DeleteEnvHsfTrafficControl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEnvHsfTrafficControlRequest is the request struct for api DeleteEnvHsfTrafficControl
type DeleteEnvHsfTrafficControlRequest struct {
	*requests.RoaRequest
	LabelAdviceName string `position:"Query" name:"LabelAdviceName"`
	PointcutName    string `position:"Query" name:"PointcutName"`
}

// DeleteEnvHsfTrafficControlResponse is the response struct for api DeleteEnvHsfTrafficControl
type DeleteEnvHsfTrafficControlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteEnvHsfTrafficControlRequest creates a request to invoke DeleteEnvHsfTrafficControl API
func CreateDeleteEnvHsfTrafficControlRequest() (request *DeleteEnvHsfTrafficControlRequest) {
	request = &DeleteEnvHsfTrafficControlRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DeleteEnvHsfTrafficControl", "/pop/v5/gray/env_hsf_traffic_control", "edas", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteEnvHsfTrafficControlResponse creates a response to parse from DeleteEnvHsfTrafficControl response
func CreateDeleteEnvHsfTrafficControlResponse() (response *DeleteEnvHsfTrafficControlResponse) {
	response = &DeleteEnvHsfTrafficControlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
