package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEnvAppGroup invokes the edas.DeleteEnvAppGroup API synchronously
func (client *Client) DeleteEnvAppGroup(request *DeleteEnvAppGroupRequest) (response *DeleteEnvAppGroupResponse, err error) {
	response = CreateDeleteEnvAppGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEnvAppGroupWithChan invokes the edas.DeleteEnvAppGroup API asynchronously
func (client *Client) DeleteEnvAppGroupWithChan(request *DeleteEnvAppGroupRequest) (<-chan *DeleteEnvAppGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteEnvAppGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEnvAppGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEnvAppGroupWithCallback invokes the edas.DeleteEnvAppGroup API asynchronously
func (client *Client) DeleteEnvAppGroupWithCallback(request *DeleteEnvAppGroupRequest, callback func(response *DeleteEnvAppGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEnvAppGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteEnvAppGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEnvAppGroupRequest is the request struct for api DeleteEnvAppGroup
type DeleteEnvAppGroupRequest struct {
	*requests.RoaRequest
	PointcutName string `position:"Query" name:"PointcutName"`
	Scopes       string `position:"Query" name:"Scopes"`
}

// DeleteEnvAppGroupResponse is the response struct for api DeleteEnvAppGroup
type DeleteEnvAppGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteEnvAppGroupRequest creates a request to invoke DeleteEnvAppGroup API
func CreateDeleteEnvAppGroupRequest() (request *DeleteEnvAppGroupRequest) {
	request = &DeleteEnvAppGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DeleteEnvAppGroup", "/pop/v5/gray/EnvAppGroups", "edas", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteEnvAppGroupResponse creates a response to parse from DeleteEnvAppGroup response
func CreateDeleteEnvAppGroupResponse() (response *DeleteEnvAppGroupResponse) {
	response = &DeleteEnvAppGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
