package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVIndex invokes the eas.ListVIndex API synchronously
// api document: https://help.aliyun.com/api/eas/listvindex.html
func (client *Client) ListVIndex(request *ListVIndexRequest) (response *ListVIndexResponse, err error) {
	response = CreateListVIndexResponse()
	err = client.DoAction(request, response)
	return
}

// ListVIndexWithChan invokes the eas.ListVIndex API asynchronously
// api document: https://help.aliyun.com/api/eas/listvindex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListVIndexWithChan(request *ListVIndexRequest) (<-chan *ListVIndexResponse, <-chan error) {
	responseChan := make(chan *ListVIndexResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVIndex(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVIndexWithCallback invokes the eas.ListVIndex API asynchronously
// api document: https://help.aliyun.com/api/eas/listvindex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListVIndexWithCallback(request *ListVIndexRequest, callback func(response *ListVIndexResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVIndexResponse
		var err error
		defer close(result)
		response, err = client.ListVIndex(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVIndexRequest is the request struct for api ListVIndex
type ListVIndexRequest struct {
	*requests.RoaRequest
}

// ListVIndexResponse is the response struct for api ListVIndex
type ListVIndexResponse struct {
	*responses.BaseResponse
}

// CreateListVIndexRequest creates a request to invoke ListVIndex API
func CreateListVIndexRequest() (request *ListVIndexRequest) {
	request = &ListVIndexRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2018-05-22", "ListVIndex", "/api/vindex", "", "")
	request.Method = requests.GET
	return
}

// CreateListVIndexResponse creates a response to parse from ListVIndex response
func CreateListVIndexResponse() (response *ListVIndexResponse) {
	response = &ListVIndexResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
