package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServiceRegion invokes the eas.GetServiceRegion API synchronously
// api document: https://help.aliyun.com/api/eas/getserviceregion.html
func (client *Client) GetServiceRegion(request *GetServiceRegionRequest) (response *GetServiceRegionResponse, err error) {
	response = CreateGetServiceRegionResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceRegionWithChan invokes the eas.GetServiceRegion API asynchronously
// api document: https://help.aliyun.com/api/eas/getserviceregion.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetServiceRegionWithChan(request *GetServiceRegionRequest) (<-chan *GetServiceRegionResponse, <-chan error) {
	responseChan := make(chan *GetServiceRegionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServiceRegion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceRegionWithCallback invokes the eas.GetServiceRegion API asynchronously
// api document: https://help.aliyun.com/api/eas/getserviceregion.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetServiceRegionWithCallback(request *GetServiceRegionRequest, callback func(response *GetServiceRegionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceRegionResponse
		var err error
		defer close(result)
		response, err = client.GetServiceRegion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceRegionRequest is the request struct for api GetServiceRegion
type GetServiceRegionRequest struct {
	*requests.RoaRequest
}

// GetServiceRegionResponse is the response struct for api GetServiceRegion
type GetServiceRegionResponse struct {
	*responses.BaseResponse
}

// CreateGetServiceRegionRequest creates a request to invoke GetServiceRegion API
func CreateGetServiceRegionRequest() (request *GetServiceRegionRequest) {
	request = &GetServiceRegionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2018-05-22", "GetServiceRegion", "/api/services/region", "", "")
	request.Method = requests.GET
	return
}

// CreateGetServiceRegionResponse creates a response to parse from GetServiceRegion response
func CreateGetServiceRegionResponse() (response *GetServiceRegionResponse) {
	response = &GetServiceRegionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
