package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetResourceStatus invokes the eas.GetResourceStatus API synchronously
// api document: https://help.aliyun.com/api/eas/getresourcestatus.html
func (client *Client) GetResourceStatus(request *GetResourceStatusRequest) (response *GetResourceStatusResponse, err error) {
	response = CreateGetResourceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetResourceStatusWithChan invokes the eas.GetResourceStatus API asynchronously
// api document: https://help.aliyun.com/api/eas/getresourcestatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetResourceStatusWithChan(request *GetResourceStatusRequest) (<-chan *GetResourceStatusResponse, <-chan error) {
	responseChan := make(chan *GetResourceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetResourceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetResourceStatusWithCallback invokes the eas.GetResourceStatus API asynchronously
// api document: https://help.aliyun.com/api/eas/getresourcestatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetResourceStatusWithCallback(request *GetResourceStatusRequest, callback func(response *GetResourceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetResourceStatusResponse
		var err error
		defer close(result)
		response, err = client.GetResourceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetResourceStatusRequest is the request struct for api GetResourceStatus
type GetResourceStatusRequest struct {
	*requests.RoaRequest
	ClusterId    string `position:"Path" name:"cluster_id"`
	ResourceName string `position:"Path" name:"resource_name"`
}

// GetResourceStatusResponse is the response struct for api GetResourceStatus
type GetResourceStatusResponse struct {
	*responses.BaseResponse
}

// CreateGetResourceStatusRequest creates a request to invoke GetResourceStatus API
func CreateGetResourceStatusRequest() (request *GetResourceStatusRequest) {
	request = &GetResourceStatusRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2018-05-22", "GetResourceStatus", "/api/resources/[cluster_id]/[resource_name]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetResourceStatusResponse creates a response to parse from GetResourceStatus response
func CreateGetResourceStatusResponse() (response *GetResourceStatusResponse) {
	response = &GetResourceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
