package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOssAuthorize invokes the eas.GetOssAuthorize API synchronously
// api document: https://help.aliyun.com/api/eas/getossauthorize.html
func (client *Client) GetOssAuthorize(request *GetOssAuthorizeRequest) (response *GetOssAuthorizeResponse, err error) {
	response = CreateGetOssAuthorizeResponse()
	err = client.DoAction(request, response)
	return
}

// GetOssAuthorizeWithChan invokes the eas.GetOssAuthorize API asynchronously
// api document: https://help.aliyun.com/api/eas/getossauthorize.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOssAuthorizeWithChan(request *GetOssAuthorizeRequest) (<-chan *GetOssAuthorizeResponse, <-chan error) {
	responseChan := make(chan *GetOssAuthorizeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOssAuthorize(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOssAuthorizeWithCallback invokes the eas.GetOssAuthorize API asynchronously
// api document: https://help.aliyun.com/api/eas/getossauthorize.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOssAuthorizeWithCallback(request *GetOssAuthorizeRequest, callback func(response *GetOssAuthorizeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOssAuthorizeResponse
		var err error
		defer close(result)
		response, err = client.GetOssAuthorize(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOssAuthorizeRequest is the request struct for api GetOssAuthorize
type GetOssAuthorizeRequest struct {
	*requests.RoaRequest
}

// GetOssAuthorizeResponse is the response struct for api GetOssAuthorize
type GetOssAuthorizeResponse struct {
	*responses.BaseResponse
}

// CreateGetOssAuthorizeRequest creates a request to invoke GetOssAuthorize API
func CreateGetOssAuthorizeRequest() (request *GetOssAuthorizeRequest) {
	request = &GetOssAuthorizeRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2018-05-22", "GetOssAuthorize", "/api/services/oss_authorize", "", "")
	request.Method = requests.GET
	return
}

// CreateGetOssAuthorizeResponse creates a response to parse from GetOssAuthorize response
func CreateGetOssAuthorizeResponse() (response *GetOssAuthorizeResponse) {
	response = &GetOssAuthorizeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
