package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteResourceInstance invokes the eas.DeleteResourceInstance API synchronously
// api document: https://help.aliyun.com/api/eas/deleteresourceinstance.html
func (client *Client) DeleteResourceInstance(request *DeleteResourceInstanceRequest) (response *DeleteResourceInstanceResponse, err error) {
	response = CreateDeleteResourceInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteResourceInstanceWithChan invokes the eas.DeleteResourceInstance API asynchronously
// api document: https://help.aliyun.com/api/eas/deleteresourceinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteResourceInstanceWithChan(request *DeleteResourceInstanceRequest) (<-chan *DeleteResourceInstanceResponse, <-chan error) {
	responseChan := make(chan *DeleteResourceInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteResourceInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteResourceInstanceWithCallback invokes the eas.DeleteResourceInstance API asynchronously
// api document: https://help.aliyun.com/api/eas/deleteresourceinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteResourceInstanceWithCallback(request *DeleteResourceInstanceRequest, callback func(response *DeleteResourceInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteResourceInstanceResponse
		var err error
		defer close(result)
		response, err = client.DeleteResourceInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteResourceInstanceRequest is the request struct for api DeleteResourceInstance
type DeleteResourceInstanceRequest struct {
	*requests.RoaRequest
	ClusterId    string `position:"Path" name:"cluster_id"`
	ResourceName string `position:"Path" name:"resource_name"`
}

// DeleteResourceInstanceResponse is the response struct for api DeleteResourceInstance
type DeleteResourceInstanceResponse struct {
	*responses.BaseResponse
}

// CreateDeleteResourceInstanceRequest creates a request to invoke DeleteResourceInstance API
func CreateDeleteResourceInstanceRequest() (request *DeleteResourceInstanceRequest) {
	request = &DeleteResourceInstanceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2018-05-22", "DeleteResourceInstance", "/api/resources/[cluster_id]/[resource_name]/instances/delete", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteResourceInstanceResponse creates a response to parse from DeleteResourceInstance response
func CreateDeleteResourceInstanceResponse() (response *DeleteResourceInstanceResponse) {
	response = &DeleteResourceInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
