package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckServiceExists invokes the eas.CheckServiceExists API synchronously
// api document: https://help.aliyun.com/api/eas/checkserviceexists.html
func (client *Client) CheckServiceExists(request *CheckServiceExistsRequest) (response *CheckServiceExistsResponse, err error) {
	response = CreateCheckServiceExistsResponse()
	err = client.DoAction(request, response)
	return
}

// CheckServiceExistsWithChan invokes the eas.CheckServiceExists API asynchronously
// api document: https://help.aliyun.com/api/eas/checkserviceexists.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckServiceExistsWithChan(request *CheckServiceExistsRequest) (<-chan *CheckServiceExistsResponse, <-chan error) {
	responseChan := make(chan *CheckServiceExistsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckServiceExists(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckServiceExistsWithCallback invokes the eas.CheckServiceExists API asynchronously
// api document: https://help.aliyun.com/api/eas/checkserviceexists.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckServiceExistsWithCallback(request *CheckServiceExistsRequest, callback func(response *CheckServiceExistsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckServiceExistsResponse
		var err error
		defer close(result)
		response, err = client.CheckServiceExists(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckServiceExistsRequest is the request struct for api CheckServiceExists
type CheckServiceExistsRequest struct {
	*requests.RoaRequest
	ServiceName string `position:"Path" name:"service_name"`
	Region      string `position:"Path" name:"region"`
}

// CheckServiceExistsResponse is the response struct for api CheckServiceExists
type CheckServiceExistsResponse struct {
	*responses.BaseResponse
}

// CreateCheckServiceExistsRequest creates a request to invoke CheckServiceExists API
func CreateCheckServiceExistsRequest() (request *CheckServiceExistsRequest) {
	request = &CheckServiceExistsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2018-05-22", "CheckServiceExists", "/api/services/[region]/[service_name]/exists", "", "")
	request.Method = requests.GET
	return
}

// CreateCheckServiceExistsResponse creates a response to parse from CheckServiceExists response
func CreateCheckServiceExistsResponse() (response *CheckServiceExistsResponse) {
	response = &CheckServiceExistsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
