package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopMigrationJob invokes the dts.StopMigrationJob API synchronously
func (client *Client) StopMigrationJob(request *StopMigrationJobRequest) (response *StopMigrationJobResponse, err error) {
	response = CreateStopMigrationJobResponse()
	err = client.DoAction(request, response)
	return
}

// StopMigrationJobWithChan invokes the dts.StopMigrationJob API asynchronously
func (client *Client) StopMigrationJobWithChan(request *StopMigrationJobRequest) (<-chan *StopMigrationJobResponse, <-chan error) {
	responseChan := make(chan *StopMigrationJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopMigrationJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopMigrationJobWithCallback invokes the dts.StopMigrationJob API asynchronously
func (client *Client) StopMigrationJobWithCallback(request *StopMigrationJobRequest, callback func(response *StopMigrationJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopMigrationJobResponse
		var err error
		defer close(result)
		response, err = client.StopMigrationJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopMigrationJobRequest is the request struct for api StopMigrationJob
type StopMigrationJobRequest struct {
	*requests.RpcRequest
	ClientToken    string `position:"Query" name:"ClientToken"`
	MigrationJobId string `position:"Query" name:"MigrationJobId"`
	OwnerId        string `position:"Query" name:"OwnerId"`
	AccountId      string `position:"Query" name:"AccountId"`
}

// StopMigrationJobResponse is the response struct for api StopMigrationJob
type StopMigrationJobResponse struct {
	*responses.BaseResponse
	ErrCode    string `json:"ErrCode" xml:"ErrCode"`
	ErrMessage string `json:"ErrMessage" xml:"ErrMessage"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Success    string `json:"Success" xml:"Success"`
}

// CreateStopMigrationJobRequest creates a request to invoke StopMigrationJob API
func CreateStopMigrationJobRequest() (request *StopMigrationJobRequest) {
	request = &StopMigrationJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "StopMigrationJob", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopMigrationJobResponse creates a response to parse from StopMigrationJob response
func CreateStopMigrationJobResponse() (response *StopMigrationJobResponse) {
	response = &StopMigrationJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
