package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SkipPreCheck invokes the dts.SkipPreCheck API synchronously
func (client *Client) SkipPreCheck(request *SkipPreCheckRequest) (response *SkipPreCheckResponse, err error) {
	response = CreateSkipPreCheckResponse()
	err = client.DoAction(request, response)
	return
}

// SkipPreCheckWithChan invokes the dts.SkipPreCheck API asynchronously
func (client *Client) SkipPreCheckWithChan(request *SkipPreCheckRequest) (<-chan *SkipPreCheckResponse, <-chan error) {
	responseChan := make(chan *SkipPreCheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SkipPreCheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SkipPreCheckWithCallback invokes the dts.SkipPreCheck API asynchronously
func (client *Client) SkipPreCheckWithCallback(request *SkipPreCheckRequest, callback func(response *SkipPreCheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SkipPreCheckResponse
		var err error
		defer close(result)
		response, err = client.SkipPreCheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SkipPreCheckRequest is the request struct for api SkipPreCheck
type SkipPreCheckRequest struct {
	*requests.RpcRequest
	SkipPreCheckItems string           `position:"Query" name:"SkipPreCheckItems"`
	Skip              requests.Boolean `position:"Query" name:"Skip"`
	JobId             string           `position:"Query" name:"JobId"`
	SkipPreCheckNames string           `position:"Query" name:"SkipPreCheckNames"`
	DtsJobId          string           `position:"Query" name:"DtsJobId"`
}

// SkipPreCheckResponse is the response struct for api SkipPreCheck
type SkipPreCheckResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	MigrationJobId string `json:"MigrationJobId" xml:"MigrationJobId"`
	ScheduleJobId  string `json:"ScheduleJobId" xml:"ScheduleJobId"`
	SkipItems      string `json:"SkipItems" xml:"SkipItems"`
	SkipNames      string `json:"SkipNames" xml:"SkipNames"`
}

// CreateSkipPreCheckRequest creates a request to invoke SkipPreCheck API
func CreateSkipPreCheckRequest() (request *SkipPreCheckRequest) {
	request = &SkipPreCheckRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "SkipPreCheck", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSkipPreCheckResponse creates a response to parse from SkipPreCheck response
func CreateSkipPreCheckResponse() (response *SkipPreCheckResponse) {
	response = &SkipPreCheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
