package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDTSIP invokes the dts.DescribeDTSIP API synchronously
func (client *Client) DescribeDTSIP(request *DescribeDTSIPRequest) (response *DescribeDTSIPResponse, err error) {
	response = CreateDescribeDTSIPResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDTSIPWithChan invokes the dts.DescribeDTSIP API asynchronously
func (client *Client) DescribeDTSIPWithChan(request *DescribeDTSIPRequest) (<-chan *DescribeDTSIPResponse, <-chan error) {
	responseChan := make(chan *DescribeDTSIPResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDTSIP(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDTSIPWithCallback invokes the dts.DescribeDTSIP API asynchronously
func (client *Client) DescribeDTSIPWithCallback(request *DescribeDTSIPRequest, callback func(response *DescribeDTSIPResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDTSIPResponse
		var err error
		defer close(result)
		response, err = client.DescribeDTSIP(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDTSIPRequest is the request struct for api DescribeDTSIP
type DescribeDTSIPRequest struct {
	*requests.RpcRequest
	SourceEndpointRegion      string `position:"Query" name:"SourceEndpointRegion"`
	DestinationEndpointRegion string `position:"Query" name:"DestinationEndpointRegion"`
}

// DescribeDTSIPResponse is the response struct for api DescribeDTSIP
type DescribeDTSIPResponse struct {
	*responses.BaseResponse
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        string `json:"Success" xml:"Success"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
}

// CreateDescribeDTSIPRequest creates a request to invoke DescribeDTSIP API
func CreateDescribeDTSIPRequest() (request *DescribeDTSIPRequest) {
	request = &DescribeDTSIPRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeDTSIP", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDTSIPResponse creates a response to parse from DescribeDTSIP response
func CreateDescribeDTSIPResponse() (response *DescribeDTSIPResponse) {
	response = &DescribeDTSIPResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
