package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryBrokerDemand invokes the domain.QueryBrokerDemand API synchronously
func (client *Client) QueryBrokerDemand(request *QueryBrokerDemandRequest) (response *QueryBrokerDemandResponse, err error) {
	response = CreateQueryBrokerDemandResponse()
	err = client.DoAction(request, response)
	return
}

// QueryBrokerDemandWithChan invokes the domain.QueryBrokerDemand API asynchronously
func (client *Client) QueryBrokerDemandWithChan(request *QueryBrokerDemandRequest) (<-chan *QueryBrokerDemandResponse, <-chan error) {
	responseChan := make(chan *QueryBrokerDemandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryBrokerDemand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryBrokerDemandWithCallback invokes the domain.QueryBrokerDemand API asynchronously
func (client *Client) QueryBrokerDemandWithCallback(request *QueryBrokerDemandRequest, callback func(response *QueryBrokerDemandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryBrokerDemandResponse
		var err error
		defer close(result)
		response, err = client.QueryBrokerDemand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryBrokerDemandRequest is the request struct for api QueryBrokerDemand
type QueryBrokerDemandRequest struct {
	*requests.RpcRequest
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	BizId       string           `position:"Query" name:"BizId"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Status      string           `position:"Query" name:"Status"`
}

// QueryBrokerDemandResponse is the response struct for api QueryBrokerDemand
type QueryBrokerDemandResponse struct {
	*responses.BaseResponse
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	TotalItemNum   int      `json:"TotalItemNum" xml:"TotalItemNum"`
	CurrentPageNum int      `json:"CurrentPageNum" xml:"CurrentPageNum"`
	PageSize       int      `json:"PageSize" xml:"PageSize"`
	TotalPageNum   int      `json:"TotalPageNum" xml:"TotalPageNum"`
	Data           []Demand `json:"Data" xml:"Data"`
}

// CreateQueryBrokerDemandRequest creates a request to invoke QueryBrokerDemand API
func CreateQueryBrokerDemandRequest() (request *QueryBrokerDemandRequest) {
	request = &QueryBrokerDemandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-02-08", "QueryBrokerDemand", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryBrokerDemandResponse creates a response to parse from QueryBrokerDemand response
func CreateQueryBrokerDemandResponse() (response *QueryBrokerDemandResponse) {
	response = &QueryBrokerDemandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
