package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FailDemand invokes the domain.FailDemand API synchronously
func (client *Client) FailDemand(request *FailDemandRequest) (response *FailDemandResponse, err error) {
	response = CreateFailDemandResponse()
	err = client.DoAction(request, response)
	return
}

// FailDemandWithChan invokes the domain.FailDemand API asynchronously
func (client *Client) FailDemandWithChan(request *FailDemandRequest) (<-chan *FailDemandResponse, <-chan error) {
	responseChan := make(chan *FailDemandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FailDemand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FailDemandWithCallback invokes the domain.FailDemand API asynchronously
func (client *Client) FailDemandWithCallback(request *FailDemandRequest, callback func(response *FailDemandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FailDemandResponse
		var err error
		defer close(result)
		response, err = client.FailDemand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FailDemandRequest is the request struct for api FailDemand
type FailDemandRequest struct {
	*requests.RpcRequest
	BizId   string `position:"Query" name:"BizId"`
	Message string `position:"Query" name:"Message"`
}

// FailDemandResponse is the response struct for api FailDemand
type FailDemandResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateFailDemandRequest creates a request to invoke FailDemand API
func CreateFailDemandRequest() (request *FailDemandRequest) {
	request = &FailDemandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-02-08", "FailDemand", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateFailDemandResponse creates a response to parse from FailDemand response
func CreateFailDemandResponse() (response *FailDemandResponse) {
	response = &FailDemandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
